<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreBanner extends VisualizzatoreComponente {
        private $datiBanner;
        private $datiCampagna;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            $this->datiBanner  = parent::getDb()->leggiSingolaRiga("geec_banner",$dati["idElemento"]);
            $queryCampagnaAttiva = "SELECT * FROM geec_campagneBanner WHERE idBanner = {$dati["idElemento"]} AND attiva LIKE 'si' LIMIT 1";
            $risCampagna = parent::getDb()->eseguiQueryLettura($queryCampagnaAttiva);
            
            if($risCampagna->num_rows > 0) {
                $this->datiCampagna = $risCampagna->fetch_assoc();
                
                if($this->datiBanner["animazione"]!="") {
                    $codiceAnimazione = "data-aos=\"{$this->datiBanner["animazione"]}\"";
                }
                else {
                    $codiceAnimazione = "";
                }

                if($this->datiCampagna ["immagine"]!="" && $this->datiCampagna ["immagineMobile"]!="") {     
                    echo"<div class=\"{$this->datiBanner["spazioOccupato"]}\"> 
                            <div class=\"{$this->datiCampagna ["spazioOccupato"]} d-none d-sm-block\" $codiceAnimazione>
                                <a href=\"javascript:void\" onclick=gestisciClick({$this->datiCampagna ["id"]},'{$this->datiCampagna["link"]}','incrementaClickBanner')>
                                    <img class=\"img-fluid\" src=\"{$this->datiCampagna ["immagine"]}\" >
                                </a>
                            </div>

                            <div class=\"col d-sm-none\" $codiceAnimazione>
                                <a href=\"javascript:void\" onclick=\"gestisciClick({$this->datiCampagna ["id"]},'{$this->datiCampagna["link"]}','incrementaClickBannerMobile')\">
                                    <img class=\"img-fluid\" src=\"{$this->datiCampagna ["immagineMobile"]}\" >
                                </a>
                            </div>
                        </div>";
                }
                else{
                    echo"<div class=\"row\"> 
                            <div class=\"{$this->datiCampagna ["spazioOccupato"]}\" $codiceAnimazione>
                                <a href=\"javascript:void\" onclick=\"gestisciClick({$this->datiCampagna ["id"]},'{$this->datiCampagna["link"]}','incrementaClickBanner')\">
                                    <img class=\"img-fluid\" src=\"{$this->datiCampagna ["immagine"]}\" >
                                </a>
                            </div>
                        </div>";
                }
            }
            else {
                parent::messaggioDiErrore("Nessuna campagna creata in questo banner");
            }
        }
        
        /*
         * Questa funzione serve quando viene stampato il componente in un articolo
         */
        function inizializzaVariabiliComponente($dati) {
            $this->datiBanner  = parent::getDb()->leggiSingolaRiga("geec_banner",$dati["idElemento"]);
            $queryCampagnaAttiva = "SELECT * FROM geec_campagneBanner WHERE idBanner = {$dati["idElemento"]} AND attiva LIKE 'si' LIMIT 1";
            $risCampagna = parent::getDb()->eseguiQueryLettura($queryCampagnaAttiva);
            if($risCampagna->num_rows > 0) {
                $this->datiCampagna = $risCampagna->fetch_assoc();
            }
        }
        
        // getter & setter, servono quando per impostare le due variabili di classe quando il componente viene 
        // invocato in un articolo o in una pagina portfolio
        function getDatiBanner() {
            return $this->datiBanner;
        }

        function getDatiCampagna() {
            return $this->datiCampagna;
        }

        function setDatiBanner($datiBanner) {
            $this->datiBanner = $datiBanner;
        }

        function setDatiCampagna($datiCampagna) {
            $this->datiCampagna = $datiCampagna;
        }

    }
